/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.validator;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.driver.oui.RemoteInventoryInfo;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.library.util.FileInfo;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.PlatformInfo;

public class WizardValidationHelper {
    private static WizardValidationHelper instance;

    private WizardValidationHelper() {
    }

    public static WizardValidationHelper getInstance() {
        if (instance == null) {
            instance = new WizardValidationHelper();
        }
        return instance;
    }

    public List<ValidationStatusMessage> validateRemoteHome(String home, List<String> nodes) {
        ArrayList<ValidationStatusMessage> errMsgs = new ArrayList<ValidationStatusMessage>();
        List nodesWithNonregisteredHome = null;
        List nodesWithMismatchingHome = null;
        for (String node : nodes) {
            if (!this.isHomeRegisteredOnNode(home, node)) {
                nodesWithNonregisteredHome = nodesWithNonregisteredHome == null ? new ArrayList() : nodesWithNonregisteredHome;
                nodesWithNonregisteredHome.add(node);
                continue;
            }
            if (this.isRemoteHomeSameAsLocalHome(home, node)) continue;
            nodesWithMismatchingHome = nodesWithMismatchingHome == null ? new ArrayList() : nodesWithMismatchingHome;
            nodesWithMismatchingHome.add(node);
        }
        if (nodesWithNonregisteredHome != null && nodesWithNonregisteredHome.size() > 0) {
            errMsgs.add(new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_REMOTEHOME_NOT_REGISTERED, new Object[]{nodesWithNonregisteredHome}));
        }
        if (nodesWithMismatchingHome != null && nodesWithMismatchingHome.size() > 0) {
            errMsgs.add(new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_REMOTEHOME_NOT_MATCHING, new Object[]{nodesWithMismatchingHome}));
        }
        return errMsgs;
    }

    private boolean isHomeRegisteredOnNode(String home, String node) {
        return RemoteInventoryInfo.getInstance((String)node).isHomeWithLocationExist(home);
    }

    private boolean isRemoteHomeSameAsLocalHome(String homeLoc, String node) {
        return RemoteInventoryInfo.getInstance((String)node).compareToLocalHome(homeLoc, node);
    }

    public StatusMessages<ValidationStatusMessage> validateRemoteWritablePermission(String location, String[] nodes) {
        StatusMessages errorMessages = new StatusMessages();
        ArrayList<String> nonWritableNodes = new ArrayList<String>();
        if (!PlatformInfo.getInstance().isWindows()) {
            for (String node : nodes) {
                if (MachineInfo.getInstance().isLocalHost(node)) {
                    String localParent = FileInfo.getLastExistingParent(location);
                    boolean isLocalLocationWritable = new File(localParent).canWrite();
                    if (isLocalLocationWritable) continue;
                    nonWritableNodes.add(node);
                    continue;
                }
                String oracleHomeRoot = FileInfo.getInstance().getLastExistingRemoteParent(node, location);
                if (FileInfo.getInstance().isRemoteDirWriatble(node, oracleHomeRoot)) continue;
                nonWritableNodes.add(node);
            }
            if (nonWritableNodes.size() > 0) {
                errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.DIRECTORY_NOT_WRITABLE_ON_NODE, new Object[]{location, ((Object)nonWritableNodes).toString()}));
            }
        }
        return errorMessages;
    }
}

